(function($) {
  $.fn.tipTip = function(options) {
    var defaults = {
      activation: "hover",
      keepAlive: false,
      maxWidth: "350px",
      edgeOffset: 8,
      defaultPosition: "bottom",
      delay: 100,
      fadeIn: 200,
      fadeOut: 200,
      attribute: "title",
      content: false,
      enter: function() {},
      exit: function() {}
    };
    var opts = $.extend(defaults, options);
    if ($("#tiptip_holder").length <= 0) {
      var tiptip_holder = $('<div id="tiptip_holder" style="max-width:' + opts.maxWidth + ';"></div>');
      var tiptip_content = $('<div id="tiptip_content"></div>');
      var tiptip_arrow = $('<div id="tiptip_arrow"></div>');
      $("body").append(tiptip_holder.html(tiptip_content).prepend(tiptip_arrow.html('<div id="tiptip_arrow_inner"></div>')))
    } else {
      var tiptip_holder = $("#tiptip_holder");
      var tiptip_content = $("#tiptip_content");
      var tiptip_arrow = $("#tiptip_arrow")
    }
    return this.each(function() {
      var org_elem = $(this);
      if (opts.content) {
        var org_title = opts.content
      } else {
        var org_title = org_elem.attr(opts.attribute)
      }
      if (org_title != "") {
        if (!opts.content) {
          org_elem.removeAttr(opts.attribute)
        }
        var timeout = false;
        if (opts.activation == "hover") {
          org_elem.hover(function() {
            active_tiptip()
          }, function() {
            if (!opts.keepAlive) {
              deactive_tiptip()
            }
          });
          if (opts.keepAlive) {
            tiptip_holder.hover(function() {}, function() {
              deactive_tiptip()
            })
          }
        } else if (opts.activation == "focus") {
          org_elem.focus(function() {
            active_tiptip()
          }).blur(function() {
            deactive_tiptip()
          })
        } else if (opts.activation == "click") {
          org_elem.click(function() {
            active_tiptip();
            return false
          }).hover(function() {}, function() {
            if (!opts.keepAlive) {
              deactive_tiptip()
            }
          });
          if (opts.keepAlive) {
            tiptip_holder.hover(function() {}, function() {
              deactive_tiptip()
            })
          }
        }

        function active_tiptip() {
          opts.enter.call(this);
          tiptip_content.html(org_title);
          tiptip_holder.hide().removeAttr("class").css("margin", "0");
          tiptip_arrow.removeAttr("style");
          var top = parseInt(org_elem.offset()['top']);
          var left = parseInt(org_elem.offset()['left']);
          var org_width = parseInt(org_elem.outerWidth());
          var org_height = parseInt(org_elem.outerHeight());
          var tip_w = tiptip_holder.outerWidth();
          var tip_h = tiptip_holder.outerHeight();
          var w_compare = Math.round((org_width - tip_w) / 2);
          var h_compare = Math.round((org_height - tip_h) / 2);
          var marg_left = Math.round(left + w_compare);
          var marg_top = Math.round(top + org_height + opts.edgeOffset);
          var t_class = "";
          var arrow_top = "";
          var arrow_left = Math.round(tip_w - 12) / 2;
          if (opts.defaultPosition == "bottom") {
            t_class = "_bottom"
          } else if (opts.defaultPosition == "top") {
            t_class = "_top"
          } else if (opts.defaultPosition == "left") {
            t_class = "_left"
          } else if (opts.defaultPosition == "right") {
            t_class = "_right"
          }
          var right_compare = (w_compare + left) < parseInt($(window).scrollLeft());
          var left_compare = (tip_w + left) > parseInt($(window).width());
          if ((right_compare && w_compare < 0) || (t_class == "_right" && !left_compare) || (t_class == "_left" && left < (tip_w + opts.edgeOffset + 5))) {
            t_class = "_right";
            arrow_top = Math.round(tip_h - 13) / 2;
            arrow_left = -12;
            marg_left = Math.round(left + org_width + opts.edgeOffset);
            marg_top = Math.round(top + h_compare)
          } else if ((left_compare && w_compare < 0) || (t_class == "_left" && !right_compare)) {
            t_class = "_left";
            arrow_top = Math.round(tip_h - 13) / 2;
            arrow_left = Math.round(tip_w);
            marg_left = Math.round(left - (tip_w + opts.edgeOffset + 5));
            marg_top = Math.round(top + h_compare)
          }
          var top_compare = (top + org_height + opts.edgeOffset + tip_h + 8) > parseInt($(window).height() + $(window).scrollTop());
          var bottom_compare = ((top + org_height) - (opts.edgeOffset + tip_h + 8)) < 0;
          if (top_compare || (t_class == "_bottom" && top_compare) || (t_class == "_top" && !bottom_compare)) {
            if (t_class == "_top" || t_class == "_bottom") {
              t_class = "_top"
            } else {
              t_class = t_class + "_top"
            }
            arrow_top = tip_h;
            marg_top = Math.round(top - (tip_h + 5 + opts.edgeOffset))
          } else if (bottom_compare | (t_class == "_top" && bottom_compare) || (t_class == "_bottom" && !top_compare)) {
            if (t_class == "_top" || t_class == "_bottom") {
              t_class = "_bottom"
            } else {
              t_class = t_class + "_bottom"
            }
            arrow_top = -12;
            marg_top = Math.round(top + org_height + opts.edgeOffset)
          }
          if (t_class == "_right_top" || t_class == "_left_top") {
            marg_top = marg_top + 5
          } else if (t_class == "_right_bottom" || t_class == "_left_bottom") {
            marg_top = marg_top - 5
          }
          if (t_class == "_left_top" || t_class == "_left_bottom") {
            marg_left = marg_left + 5
          }
          tiptip_arrow.css({
            "margin-left": arrow_left + "px",
            "margin-top": arrow_top + "px"
          });
          tiptip_holder.css({
            "margin-left": marg_left + "px",
            "margin-top": marg_top + "px"
          }).attr("class", "tip" + t_class);
          if (timeout) {
            clearTimeout(timeout)
          }
          timeout = setTimeout(function() {
            tiptip_holder.stop(true, true).fadeIn(opts.fadeIn)
          }, opts.delay)
        }

        function deactive_tiptip() {
          opts.exit.call(this);
          if (timeout) {
            clearTimeout(timeout)
          }
          tiptip_holder.fadeOut(opts.fadeOut)
        }
      }
    })
  }
})(jQuery);

$(document).click(function(a) {
  $(a.target).closest(".wrap_transfer, .maddm").length || ($(".wrap_transfer").remove(), $(a.target).closest(".walls_gift, .wrap_walls_gift").length || ($(".wrap_walls_gift").html("").css({
    top: 0
  }), a.stopPropagation()))
});
var reloadpage = {
  leftprofiles: function() {
    $(".leftprofiles").load("modules/profiles/leftprofiles.php");
    $("#tiptip_holder").css({
      display: "none"
    })
  },
  loadklink: function() {
    $(".klink").load("modules/klink/klink.php");
    $("#tiptip_holder").css({
      display: "none"
    })
  },
  loadchain: function() {
    $(".chain").load("modules/advertising-chain/chain.php");
    $("#tiptip_holder").css({
      display: "none"
    })
  },
  loadban2x3: function() {
    $(".ban2x3").load("modules/banner200x300/rotator.php");
    $("#tiptip_holder").css({
      display: "none"
    })
  },
  loadtoppanel: function() {
    $(".topmenu").load("modules/topmenu.php");
    $("#tiptip_holder").css({
      display: "none"
    })
  },
  /*rightprofiles: function(a) { /// ЗАКОМЕНТИРОВАНО ТАК КАК ПРАВЫЙ БЛОК УБРАН
    $(".right_menu").load("modules/rightmenu.php", "type=" + a);
    $("#tiptip_holder").css({
      display: "none"
    })
  },*/
  loadchain: function(a) {
    $(".chain").load("modules/advertising-chain/chain.php", "type=" + a);
    $("#tiptip_holder").css({
      display: "none"
    })
  }
};
window.onload = function() {
  window.onpopstate = function(a) {
    a.preventDefault();
   /// Page.Go(a.state.link, "no") ТУТ ОБРАТИТЬ ВНИМАНИЕ И РОСКОМЕНТИРОВАТЬ ЕСЛИ БУдУТ ПРОБЛЕМЫ С ФУЛЛ АЯКСОМ
  }
};
var Page = {
    Go: function(a, b) {
      "Microsoft Internet Explorer" == navigator.appName && 9 >= navigator.appVersion.match(/MSIE\u0020([.\d]+);/)[1] ? window.location.href = a : "no" != b && history.pushState({
        link: a
      }, null, a);
      $(".body").load(a, {
        ajax: "yes"
      });
      $("#tiptip_holder").css({
        display: "none"
      });
      $("#nftitle").remove();
      $(".js_titleRemove").remove();
      ///a == "http://" + location.host + "/tasks" ? reloadpage.rightprofiles("tasks") : reloadpage.rightprofiles(""); /// ЗАКОМЕНТИРОВАНО ТАК КАК ПРАВЫЙ БЛОК УБРАН
      reloadpage.loadchain("");
      reloadpage.leftprofiles();
      "undefined" != typeof setIid && clearInterval(setIid)
    },
    RefType: function(a) {
      addCookie("reftype", a, $(".body").load("/modules/referrals/referrals.php?type=" + a));
      return !1
    },
	RefType1:function(a){
	  addCookie("reftype1", a,$(".body").load("/modules/fair/fair.php?type="+a));
	  return!1
	},
    RefType2: function(a) {
      addCookie("reftype2", a, $(".body").load("/modules/referrals/free_referrals.php?type=" + a));
      return !1
    }
  },
  forum = {
    NewMsg: function(a) {
      $.post("ajax.php?func=forumnewmsg", {
        id: a,
        msg: $("#forum_msg").val()
      }, function(b) {
          1 == b.ok ? (Page.Go('')) 
		: ($("body").Qnotify({
            text: b.error,
            sound: "error"
          }))
      }, "json");
      return !1
    },
    Quote: function(a) {
      document.getElementById('forum_msg').value += ("[quote]" + a + "[/quote]");
      $(".wrap_body").scrollTop(1E4);
      return !1
    },
    DelMsg: function(a) {
      $.post("ajax.php?func=forumdelmsg", {
        id: a
      }, function(b) {
        1 == b && ($(".js_titleRemove").remove(), $("#t" + a).remove())
      });
      return !1
    },
    DelTopic: function(a) {
      $.post("ajax.php?func=deltopic", {
        id: a
      }, function(b) {
        1 == b && (Page.Go(''))
      });
      return !1
    },
    CloseTopic: function(a, b) {
      $.post("ajax.php?func=closetopic", {
        id: a
      }, function(b) {
        1 == b ? (Page.Go('')) : 2 == b && (Page.Go(''))
      });
      return !1
    },
    BlockMes: function(a) {
      $.post("ajax.php?func=forumblockmes", {
        id: a
      }, function(a) {
        $(".body").Qnotify({
          text: a,
          sound: "error"
        })
      });
      return !1
    },
    ShowSmilesTopic: function() {
      if ("" == $(".wrap_smiles").html()) {
        $(".wrap_smiles").css({
          width: "600px"
        }).fadeIn(100).animate({
          "margin-top": "-200px"
        }, 300);
         $(".wrap_smiles").append('<div class="smile_arrow_bot_forum" ></div><div style="height: 168px; overflow-y: scroll;" class="body_smile"></div>');
        for (var a = 1; 123 >= a; a++) $(".body_smile").append('<img src="theme/images/smile/' + a + '.gif" alt="" class="img_smile" onclick="forum.AddSmileTopic(' + a + ');" />')
      } else $(".wrap_smiles").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-200px"
      })
    },
    ShowSmilesText: function() {
      if ("" == $(".wrap_smiles").html()) {
        $(".wrap_smiles").css({
          width: "600px"
        }).fadeIn(100).animate({
          "margin-top": "-200px"
        }, 300);
         $(".wrap_smiles").append('<div class="smile_arrow_bot_forum" ></div><div style="height: 168px; overflow-y: scroll;" class="body_smile"></div>');
        for (var a = 1; 123 >= a; a++) $(".body_smile").append('<img src="theme/images/smile/' + a + '.gif" alt="" class="img_smile" onclick="forum.AddSmileText(' + a + ');" />')
      } else $(".wrap_smiles").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-200px" 
      })
    }, 
    ShowSmiles: function() {
      if ("" == $(".wrap_smiles_forum_post").html()) {
        $(".wrap_smiles_forum_post").css({
          width: "600px"
        }).fadeIn(100).animate({
          "margin-top": "-610px"
        }, 300);
         $(".wrap_smiles_forum_post").append('<div class="smile_arrow_bot_forum_post" ></div><div style="height: 578px; " class="body_smile"></div>');
        for (var a = 1; 123 >= a; a++) $(".body_smile").append('<img src="theme/images/smile/' + a + '.gif" alt="" class="img_smile" onclick="forum.AddSmile(' + a + ');" />')
      } else $(".wrap_smiles_forum_post").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-610px"
      })
    },
	AddSmileTopic: function(a) {
      if ("" != a) {
        var b = document.getElementById("message-text");
        a = " [:" + a + ":] ";
        if (document.selection) {
          b.focus();
          var c = b.value,
            d = document.selection.createRange();
          "" == d.text ? d.text = a : -1 != c.indexOf(d.text) ? d.text = a + d.text : b.value = c + a
        } else b.value += a
      }
      $(".wrap_smiles").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-200px"
      })
    },
	AddSmileText: function(a) {
      if ("" != a) {
        var b = document.getElementById("text");
        a = " [:" + a + ":] ";
        if (document.selection) {
          b.focus();
          var c = b.value,
            d = document.selection.createRange();
          "" == d.text ? d.text = a : -1 != c.indexOf(d.text) ? d.text = a + d.text : b.value = c + a
        } else b.value += a
      }
      $(".wrap_smiles").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-200px"
      })
    },
	AddSmile: function(a) {
      if ("" != a) {
        var b = document.getElementById("forum_msg");
        a = " [:" + a + ":] ";
        if (document.selection) {
          b.focus();
          var c = b.value,
            d = document.selection.createRange();
          "" == d.text ? d.text = a : -1 != c.indexOf(d.text) ? d.text = a + d.text : b.value = c + a
        } else b.value += a
      }
      $(".wrap_smiles_forum_post").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-610px"
      })
    },
    Newtopic: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/forum_new_topic.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    }
  };

function delHistory(a, b) {
  $.post("ajax.php?func=delhistory", {
    id: a,
    type: b
  }, function(b) {
    1 == b && location.reload();
  });
  return !1
}
var msg = {
    showDialog: function(a, b) {
      /*settings.setClose(a);*/
      ($("#modal_windows_open").load("modules/modal_windows/new_message.php?id=" + a, "type=" + b), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	},
    Send: function(a, b) {
      var c = $("#msgSend").attr("onclick");
      $("#msgSend").attr("onclick", "");
      $(".preloader").css({
        display: "block"
      });
      $.post("ajax.php?func=newmsg", {
        id: a,
        text: $("#msgtext").val(),
        type: b
      }, function(a) {
        1 == a ? box_close() : (2 == a ? $("#msgtext").focus() : $(".body").Qnotify({
          text: a,
          sound: "error"
        }), $(".preloader").css({
          display: "none"
        }), $("#msgSend").attr("onclick", c))
      });
      return !1
    },
    Send_d: function(a, b, c) {
      
      $.post("ajax.php?func=newmsg", {
        id: a,
        text: b,
        type: c
      }, function(b) {
        1 == b ? ($("#msgtext").val(""), Page.Go("mread=" + a, "no")) : 2 == b ? ($(".preload_msg").css({
          display: "none"
        }), $("#msgtext").val("").focus()) : ($(".body").Qnotify({
          text: b,
          sound: "error"
        }))
      });
      return !1
    },
    Del_in: function(a) {
      $.post("ajax.php?func=delmsgin", {
        id: a
      }, function(b) {
        1 == b && ($("#del_" + a).parents(".wrap_in_mess").remove(), $("#js_title_" + a).remove())
      })
    },
    Del_out: function(a) {
      $.post("ajax.php?func=delmsgout", {
        id: a
      }, function(b) {
        1 == b && ($("#del_" + a).parents(".wrap_in_mess").remove(), $("#js_title_" + a).remove())
      })
    },
    Del_in_all: function(a) {
      $.post("ajax.php?func=delmsginall", {
        id: a
      }, function(a) {
        1 == a && (Page.Go("msg=inbox"), reloadpage.leftprofiles())
      })
    },
    Del_out_all: function(a) {
      $.post("ajax.php?func=delmsgoutall", {
        id: a
      }, function(a) {
        1 == a && Page.Go("msg=outbox")
      })
    }
  },
  chat = {
    Send: function(a, b, c) {
      $.post("ajax.php?func=newchat", {
        text: a
      }, function(b) {
        1 == b ? ($("#msgtext").val(""), Page.Go("chat", "no")) : 2 == b ? ($(".preload_msg").css({
          display: "none"
        }), $("#msgtext").val("").focus()) : ($(".body").Qnotify({
          text: b,
          sound: "error"
        }))
      });
      return !1
    },
    Dell_mess: function(a) {
      $.post("ajax.php?func=dellchat", {
        id: a
      }, function(b) {
        1 == b ? ($('#mess_d'+a).fadeOut(300)) : ($(".body").Qnotify({
          text: b,
          sound: "error"
        }))
      });
      return !1
    },
	Ban: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/chat_black_add.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
	Ban_list: function() {
      ($("#modal_windows_open").load("modules/modal_windows/chat_ban_list.php"), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
	Rules: function() {
      ($("#modal_windows_open").load("modules/modal_windows/chat_rules.php"), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    }
  },
  board = {
    Rules: function() {
      ($("#modal_windows_open").load("modules/modal_windows/board_rules.php"), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    }
  },
  adv = {
    Remove_advertising: function(a, b) {
      ($("#modal_windows_open").load("modules/modal_windows/remove_advertising.php?id=" + a, "type=" + b), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    }
  },
  function_ref = {
    Info: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/user_info.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    Fair: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/fair_add.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    Reward: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/referrals_reward.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    Refback: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/change_refback.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    Alert: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/delte_referrals.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    RemoveRef: function(a) {
      $.post("ajax.php?func=delreferer", {
        id: a
      }, function(a) {
        1 == a && (box_close(), Page.Go("/mstatistic"))
      });
      return !1
    },
    Wake: function(a, b) {
      ($("#modal_windows_open").load("modules/modal_windows/wake_up_referral.php?id=" + a, "erol=" + b), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	}
  }
  walls = {
    AddReferer: function(a) {
      $.post("ajax.php?func=addreferer", {
        id: a
      }, function(b) {
        if (b == 1) {
			Page.Go("id" + a);
		} else {
			$('body').Qnotify({text:b, sound:'error'});
		}
      });
      return !1
    },
    AddGift: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/addgift.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
    },
    SendGift: function(a, b) {
      $.post("ajax.php?func=sendgift", {
        id: a,
        img: b,
        comms: $("#walls_comms_gift").val()
      },  function(b) {
			if (b == 1) {
				$("#gif_open").fadeOut(300);
				$("#send_walls_gift").fadeOut(0);
				$("#success_text").fadeIn(0);

			} else {
				$('.error_wall_modal').fadeIn(500).html(b);
				setTimeout(function() {
					$('.error_wall_modal').fadeOut(300).html('&nbsp;');
				}, 7000);
			}
		});
      return !1
    },
    ShowGift: function(a, b) {
      $("body").Qbox({
        title: "\u041f\u043e\u0434\u0430\u0440\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + b,
        width: 630,
        height: 274,
        fadespeed: 300,
        url: "/modules/walls/gift.php",
        param: "id=" + a,
        data: ""
      });
      return !1
    },
    BigGift: function(a, b) {
      $(".prev_big_gift").html('<img src="theme/images/gift/big/' + a + '.jpg" width="206" height="206" alt="" />');
      $(".comm_gift_user").html(b)
    },
    ShowMess: function() {
      "none" == $(".wrap_walls_add").css("display") ? $(".wrap_walls_add").fadeIn(500) : $(".wrap_walls_add").fadeOut(500)
    },
    AddWallsMsg: function(a, b, c) {
      $.post("ajax.php?func=addwallsmsg", {
        id: a,
        mess: b,
        type: c
      }, function(b) {
			if (b == 1) {
				Page.Go(window.location.href);
			} else {
				$('.error_wall_comment').fadeIn(500).html(b);
				setTimeout(function() {
					$('.error_wall_comment').fadeOut(300).html('&nbsp;');
				}, 5000);
			}
		});
      return !1
    },

	ShowSmiles: function() {
      if ("" == $(".wrap_smiles").html()) {
        $(".wrap_smiles").css({
          width: "650px"

        }).fadeIn(100).animate({
          "margin-top": "-563px"
        }, 300);
        $(".wrap_smiles").append('<div class="smile_arrow_bot"></div><div class="body_smile"></div>');
        for (var a = 1; 123 >= a; a++) $(".body_smile").append('<img src="theme/images/smile/' + a + '.gif" alt=""  class="img_smile" onclick="walls.AddSmile(' + a + ');" />')
      } else $(".wrap_smiles").html("").fadeOut(0).css({
        width: 0,
        "margin-top": "-563px"
      })
    },

	AddSmile: function(a) {
      if ("" != a) {
        var b = document.getElementById("walls_mess");
        a = " [:" + a + ":] ";
        if (document.selection) {
          b.focus();
          var c = b.value,
            d = document.selection.createRange();
          "" == d.text ? d.text = a : -1 != c.indexOf(d.text) ? d.text = a + d.text : b.value = c + a
        } else { b.value += a }
      } else {
		$(".wrap_smiles").html("").fadeOut(0).css({
		  width: 0,
		  "margin-top": "-563px"
		})
	  }
    },

	MsgDel: function(a) {
      $.post("ajax.php?func=delwallsmsg", {
        id: a
      }, function(b) {
        1 == b && ($("#del_" + a).parents(".wrap_in_mess").remove(), $("#js_title_" + a).remove())
      });
      return !1
    }
  },
  adv_ell = {
	complaints: function (a, b) {
		($("#modal_windows_open").load("modules/modal_windows/complaints.php?id=" + a, "type=" + b), $("#modal_windows_open").animate({top: "10px"}, 300))
	} 
  },
  competition = {
	complaints_adm: function (a, b) {
		($("#modal_windows_open").load("modules/modal_windows/complaints_competition.php?id=" + a, "type=" + b), $("#modal_windows_open").animate({top: "10px"}, 300))
	} 
  },
  register = {
	referer: function () {
		($("#modal_windows_open").load("modules/modal_windows/referer_open_reg.php"), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	} 
  },
  titlehtml = {
    title: function(a, b, c, d) {
      d || (d = -5);
      $("body").append('<div id="js_title_' + a + '" class="js_titleRemove"><div id="easyTooltip">' + b + '</div><div class="tooltip"></div></div>');
      xOffset = $("#" + c + a).offset().left + d;
      yOffset = $("#" + c + a).offset().top - 32;
      $("#js_title_" + a).css("position", "absolute").css("top", yOffset + "px").css("left", xOffset + "px").css("display", "none").fadeIn("fast");
      $("#" + c + a).mouseout(function() {
        $(".js_titleRemove").remove()
      })
    },
    title_close: function(a) {
      $("#js_title_" + a).remove()
    }
  },
  transfer = {
    Show: function(a, b) {
      $(".wrap_transfer").remove();
      $(".table_body").append('<div class="wrap_transfer" id="wrap_transfer_' + a + '"><div class="transfer_arrow"></div><div class="title_transfer">\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0436\u0434\u0443 \u0440\u0435\u043a\u043b\u0430\u043c\u043d\u044b\u043c\u0438 \u043f\u043b\u043e\u0449\u0430\u0434\u043a\u0430\u043c\u0438<div class="transfer_close" onclick="transfer.Close(' + a + ');"></div></div><div class="body_transfer"></div></div>');
      yOffset = $("#maddm" + a).offset().top - 24 + $(".wrap_body").scrollTop();
      xOffset = $("#maddm" + a).offset().left - 368;
      $("#wrap_transfer_" + a).css("top", yOffset + "px").css("left", xOffset + "px").fadeIn(1E3);
      $.post("modules/transfer_adv.php", {
        id: a,
        type: b
      }, function(a) {
        $(".wrap_transfer").fadeIn(500).animate({
          top: yOffset - 5 + "px"
        }, 300);
        $(".body_transfer").html(a)
      });
      return !1
    },
    Close: function(a) {
      $("#wrap_transfer_" + a).remove();
      $("a.medit").css({
        display: "none"
      });
      $("a.maddm").css({
        display: ""
      });
      $("a.mdel").css({
        display: "none"
      });
      $("a.mblack_lick").css({
        display: "none"
      })
    },
    Send: function(a, b) {
      var c = $("#transferSend").attr("onclick");
      $("#transferSend").attr("onclick", "");
      $(".preloader").css({
        display: "block"
      });
      $.post("ajax.php?func=transfer_send", {
        id: a,
        type: b,
        rek_area: $("#rek_area").val(),
        id_area: $("#rek_id").val(),
        sum: $("#sum").val()
      }, function(b) {
        1 == b ? ($("#wrap_transfer_" + a).remove(), Page.Go(document.location.pathname)) : ($(".preloader").css({
          display: "none"
        }), $("#transferSend").attr("onclick", c))
      });
      return !1
    }
  },
  /*settings = { удалить
    setOpen: function(a) {
      $(".setMenu").hide();
      $("#setMenu_" + a).fadeIn(300)
    },
    setClose: function(a) {
      $("#setMenu_" + a).fadeOut(300)
    },
    typerefOpen: function() {
      $(".typeref").fadeIn(300)
    },
    typerefClose: function(a) {
      $(".typeref").fadeOut(300)
    },
    privacyOpen: function(a) {
      $(".pMenu").hide();
      $("#p_" + a).fadeIn(300)
    },
    privacyClose: function(a) {
      $("#p_" + a).fadeOut(300)
    }
  },*/
  catalog = {
    Show: function() {
      ($("#modal_windows_open").load("modules/modal_windows/catalog_new_site.php"), $("#modal_windows_open").animate({top: "10px"}, 300))
    }
  },
  birthday = {
    Add: function() {
      ($("#modal_windows_open").load("modules/modal_windows/birthday.php"), $("#modal_windows_open").animate({top: "10px"}, 300))
    }
  },
  tasks = {
    ShowComment: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/task_commentars.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	},
	NewComment: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/task_new_commentars.php?id=" + a), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	},
  },
  help = {
    Show_cookie: function(a) {
      ($("#modal_windows_open").load("modules/modal_windows/show_help_cookie.php"), $("#modal_windows_open").animate({top: "10px"}, 300)) 
	},
  };

function addCookie(a, b, c, d) {
  setCookie(a, b, c);
  d;
  return !1
}

function setCookie(a, b, c, d, e, f) {
  document.cookie = a + "=" + escape(b) + (c ? "; expires=" + c : "") + (d ? "; path=" + d : "") + (e ? "; domain=" + e : "") + (f ? "; secure" : "")
}

function windowHeight() {
  return "CSS1Compat" == document.compatMode ? document.documentElement.clientHeight : document.body.clientHeight
};

function qbb(a, b, c) {
  textarea = document.getElementById(c);
  if (document.selection && document.selection.createRange) textarea.focus(), sel = document.selection.createRange(), sel.text = a + sel.text + b;
  else if (textarea.selectionStart || "0" == textarea.selectionStart) {
    c = textarea.selectionStart;
    var d = textarea.selectionEnd;
    textarea.value = textarea.value.substring(0, c) + a + textarea.value.substring(c, d) + b + textarea.value.substring(d, textarea.value.length);
    textarea.selectionStart = textarea.selectionEnd = d + a.length + b.length
  } else textarea.value += a + b;
  textarea.focus()
};

var divId, nftitle = {
  Show: function(e, c, d, m, g, n, p) {
    var k = document.getElementById(e).getBoundingClientRect(),
      h, f = 0.1,
      l, b = document.getElementById("nftitle");
    if (null != b) {
      if (divId == e) return;
      b.parentNode.removeChild(b)
    }
    divId = e;
    b = document.createElement("div");
    b.className = "wrap-nftitle";
    b.id = "nftitle";
    b.innerHTML = '<div id="nftitle-out"><div id="nftitle-in"></div></div><div id="nftitle-title">' + c + '</div><div id="nftitle-body">' + d + "</div>";
    document.body.appendChild(b);
    var a = document.getElementById("nftitle");
    c = document.getElementById("nftitle-out");
    d = document.getElementById("nftitle-in");
    b = document.getElementById("nftitle-title");
    document.getElementById("nftitle-body");
    b.style.color = "#335783";
    b.style.fontWeight = "bold";
    b.style.padding = "7px 10px";
    b.style.background = "#f2f2f2";
    b.style.borderBottom = "1px solid #dae1e8";
    a.style.display = "inline-block;";
    h = parseInt(k.top - a.offsetHeight - 6 - g);
    g = parseInt(k.left - 20 - n);
    a.style.border = "1px solid #ADBAC7";
    a.style.position = "absolute";
    a.style.top = h + "px";
    a.style.left = g + "px";
    a.style.zIndex = 50;
    a.style.background = "#ffffff";
    a.style.opacity = 0;
    a.style.fontSize = "10px";
    a.style.fontFamily = "Tahoma";
    a.style.width = m;
    a.style.boxShadow = "0 0 2px rgba(0,0,0,0.2)";
    c.style.position = "absolute";
    c.style.bottom = "-6px";
    c.style.borderLeft = "6px solid transparent";
    c.style.borderRight = "6px solid transparent";
    c.style.borderTop = "6px solid #ADBAC7";
    c.style.zIndex = 52;
    c.style.left = document.getElementById(e).offsetWidth / 2 + 14 + "px";
    d.style.position = "absolute";
    d.style.top = "-6px";
    d.style.borderLeft = "5px solid transparent";
    d.style.borderRight = "5px solid transparent";
    d.style.borderTop = "5px solid #ffffff";
    d.style.zIndex = 51;
    d.style.left = "-5px";
    1 > f && (l = setInterval(function() {
      f += 0.1;
      1 <= f ? clearInterval(l) : (a.style.opacity = f, a.style.top = h + 10 * f + "px")
    }, 25));
    p ? document.onclick = function(a) {
      for (var b = 0; b < document.getElementById("nftitle-body").childNodes.length; b++)
        if (a.target == document.getElementById("nftitle-body").childNodes[b] || "nftitle-title" == a.target.id || "nftitle-body" == a.target.id) return;
      null != document.getElementById("nftitle") && document.getElementById("nftitle").parentNode.removeChild(document.getElementById("nftitle"))
    } : null != document.getElementById(e) && (document.getElementById(e).onmouseout = function() {
      document.getElementById("nftitle").parentNode.removeChild(document.getElementById("nftitle"))
    })
  }
};

(function(c) {
  "function" === typeof define && define.amd ? define(["jquery"], c) : "object" === typeof exports ? module.exports = c : c(jQuery)
})(function(c) {
  function m(b) {
    var a = b || window.event,
      g = [].slice.call(arguments, 1),
      d = 0,
      e = 0,
      h = 0,
      f = 0,
      f = 0;
    b = c.event.fix(a);
    b.type = "mousewheel";
    a.wheelDelta && (d = a.wheelDelta);
    a.detail && (d = -1 * a.detail);
    a.deltaY && (d = h = -1 * a.deltaY);
    a.deltaX && (e = a.deltaX, d = -1 * e);
    void 0 !== a.wheelDeltaY && (h = a.wheelDeltaY);
    void 0 !== a.wheelDeltaX && (e = -1 * a.wheelDeltaX);
    f = Math.abs(d);
    if (!l || f < l) l = f;
    f = Math.max(Math.abs(h), Math.abs(e));
    if (!k || f < k) k = f;
    a = 0 < d ? "floor" : "ceil";
    d = Math[a](d / l);
    e = Math[a](e / k);
    h = Math[a](h / k);
    g.unshift(b, d, e, h);
    return (c.event.dispatch || c.event.handle).apply(this, g)
  }
  var n = ["wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll"],
    g = "onwheel" in document || 9 <= document.documentMode ? ["wheel"] : ["mousewheel", "DomMouseScroll", "MozMousePixelScroll"],
    l, k;
  if (c.event.fixHooks)
    for (var p = n.length; p;) c.event.fixHooks[n[--p]] = c.event.mouseHooks;
  c.event.special.mousewheel = {
    setup: function() {
      if (this.addEventListener)
        for (var b = g.length; b;) this.addEventListener(g[--b], m, !1);
      else this.onmousewheel = m
    },
    teardown: function() {
      if (this.removeEventListener)
        for (var b = g.length; b;) this.removeEventListener(g[--b], m, !1);
      else this.onmousewheel = null
    }
  };
  c.fn.extend({
    mousewheel: function(b) {
      return b ? this.bind("mousewheel", b) : this.trigger("mousewheel")
    },
    unmousewheel: function(b) {
      return this.unbind("mousewheel", b)
    }
  })
});


























